/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class FirstOrder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -7500464545400454179L;
    protected Range m_DeltaCols = new Range();

    public String globalInfo() {
        return "This instance filter takes a range of N numeric attributes and replaces them with N-1 numeric attributes, the values of which are the difference between consecutive attribute values from the original instance. eg: \n\nOriginal attribute values\n\n   0.1, 0.2, 0.3, 0.1, 0.3\n\nNew attribute values\n\n   0.1, 0.1, -0.2, 0.2\n\nThe range of attributes used is taken in numeric order. That is, a range spec of 7-11,3-5 will use the attribute ordering 3,4,5,7,8,9,10,11 for the differences, NOT 7,8,9,10,11,3,4,5.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSpecify list of columns to take the differences between.\n\tFirst and last are valid indexes.\n\t(default none)", "R", 1, "-R <index1,index2-index4,...>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String deltaList = Utils.getOption('R', options);
        if (deltaList.length() != 0) {
            this.setAttributeIndices(deltaList);
        } else {
            this.setAttributeIndices("");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (!this.getAttributeIndices().equals("")) {
            options[current++] = "-R";
            options[current++] = this.getAttributeIndices();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_DeltaCols.setUpper(this.getInputFormat().numAttributes() - 1);
        int selectedCount = 0;
        int i = this.getInputFormat().numAttributes() - 1;
        while (i >= 0) {
            if (this.m_DeltaCols.isInRange(i)) {
                ++selectedCount;
                if (!this.getInputFormat().attribute(i).isNumeric()) {
                    throw new UnsupportedAttributeTypeException("Selected attributes must be all numeric");
                }
            }
            --i;
        }
        if (selectedCount == 1) {
            throw new Exception("Cannot select only one attribute.");
        }
        FastVector<Attribute> newAtts = new FastVector<Attribute>();
        boolean inRange = false;
        String foName = null;
        int clsIndex = -1;
        int i2 = 0;
        while (i2 < instanceInfo.numAttributes()) {
            if (this.m_DeltaCols.isInRange(i2) && i2 != instanceInfo.classIndex()) {
                if (inRange) {
                    Attribute newAttrib = new Attribute(foName);
                    newAtts.addElement(newAttrib);
                }
                foName = instanceInfo.attribute(i2).name();
                foName = "'FO " + foName.replace('\'', ' ').trim() + '\'';
                inRange = true;
            } else {
                newAtts.addElement((Attribute)instanceInfo.attribute(i2).copy());
                if (i2 == instanceInfo.classIndex()) {
                    clsIndex = newAtts.size() - 1;
                }
            }
            ++i2;
        }
        Instances data = new Instances(instanceInfo.relationName(), newAtts, 0);
        data.setClassIndex(clsIndex);
        this.setOutputFormat(data);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instances outputFormat = this.outputFormatPeek();
        double[] vals = new double[outputFormat.numAttributes()];
        boolean inRange = false;
        double lastVal = Utils.missingValue();
        int i = 0;
        int j = 0;
        while (j < outputFormat.numAttributes()) {
            if (this.m_DeltaCols.isInRange(i) && i != instance.classIndex()) {
                if (inRange) {
                    vals[j++] = Utils.isMissingValue(lastVal) || instance.isMissing(i) ? Utils.missingValue() : instance.value(i) - lastVal;
                } else {
                    inRange = true;
                }
                lastVal = instance.value(i);
            } else {
                vals[j++] = instance.value(i);
            }
            ++i;
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
        return true;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_DeltaCols.getRanges();
    }

    public void setAttributeIndices(String rangeList) throws Exception {
        this.m_DeltaCols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] argv) {
        FirstOrder.runFilter(new FirstOrder(), argv);
    }
}

